<?php
	
// Funciones generales
	define( "SEPARADOR", " - ");
	function AJAX_ERROR($mensaje)
	{
		$arr = array('status' => "ERR", 'message' => $mensaje);
		return json_encode($arr);
	}

	function AJAX_OK()
	{
		$arr = array('status' => "OK");
		return json_encode($arr);
	}


	function __GetType( $type )
	{
		$type=strtoupper($type);
		
		$numeros=[ "CHAR", "VARCHAR", "TEXT" ];
		foreach($numeros as $num)
			if( strpos($type, $num)!==false )
				return "C";
			
		$numeros=[ "INT", "LONG", "DECIMAL", "DOBLE", "FLOAT", "REAL" ];
		foreach($numeros as $num)
			if( strpos($type, $num)!==false )
				return "N";
				
		$numeros=[ "DATE", "DATETIME" ];
		foreach($numeros as $num)
			if( strpos($type, $num)!==false )
				return "D";
			
		return "X";
	}

	function __GetTableData($odonto_connection, $table, &$data, &$index)
	{
		$data=null;
		
		
		$sql ="DESCRIBE $table";
		$resultado = mysqli_query($odonto_connection,$sql);
		if($resultado)
		{

			$data = array();
			$index = array();

			while( ($fila = mysqli_fetch_assoc($resultado)) )
			{
				if( $fila[ "Key" ] === "PRI" )
				{
					$index[ $fila["Field"] ][ "Type" ] = __GetType( $fila[ "Type" ] );
					$index[ $fila["Field"] ][ "Null"  ] = ( $fila[ "Null" ] === "YES" ) ;
				}
				else
				{
					$data[ $fila["Field"] ][ "Type" ] = __GetType( $fila[ "Type" ] );
					$data[ $fila["Field"] ][ "Null"  ] = ( $fila[ "Null" ] === "PRI" );
				}
			}
		}

		return $data;
	}

	function __TransformData( $campo, $tipo)
	{		
		if( $tipo == "C" )
			//return "'$campo'";
			return "'" . utf8_decode( $campo ) ."'";
		
		if( $tipo == "D" )
			return "'$campo'";
		
		if( $tipo == "N" )
			return $campo;
		
		$campo;
	}

	function Insert($odonto_connection, $table, $data)
	{
		$fields = array();
		$index = array();
		__GetTableData($odonto_connection, $table, $fields, $index);
		
		//echo AJAX_ERROR( print_r($data, true));
		
		$f = array();
		$d = array();
		
		foreach( $fields as $campo => $datos )
		{
			if( isset($data[ $campo ]) )
			{
				$x=$data[ $campo ];
				$e=__TransformData( $x, $datos[ "Type" ]);
				//echo AJAX_ERROR( "$campo=$e ($x)");
				$f[]=$campo;
				$d[]=$e;
			}
		}
		
		$sql="INSERT INTO $table (" . implode(",",$f) . ") VALUES(" . implode(",",$d) . ")";
		//echo AJAX_ERROR($sql); 
		if( $stmt=mysqli_prepare( $odonto_connection, $sql) )
		{
			if( mysqli_stmt_execute( $stmt ) )
				return mysqli_stmt_insert_id(  $stmt );
		}
		return false;
	}

	function Update($odonto_connection, $table, $data)
	{
		$fields = array();
		$index = array();
		__GetTableData($odonto_connection, $table, $fields, $index);
		
		$d = array();
		$w = array();
		
		foreach( $fields as $campo => $datos )
		{
			if( isset($data[ $campo ]) )
				$d[]="$campo=" . __TransformData( $data[ $campo ], $datos[ "Type" ]);
		}
		
		foreach( $index as $campo => $datos )
		{
			if( isset($data[ $campo ]) )
				$w[]="$campo=" . __TransformData( $data[ $campo ], $datos[ "Type" ]);
		}
		
		$sql="UPDATE $table SET " . implode(",",$d) . "  WHERE " . implode(" AND ",$w);
		if( $stmt=mysqli_prepare( $odonto_connection, $sql) )
		{
			if( mysqli_stmt_execute( $stmt ) )
				return true;
		}
		return false;
	}

	function CrearSelect($nombre, $tabla, $clave, $descripcion)
	{
		global $odonto_connection;
			
		$html.="<select name=\"$nombre\" id=\"id_tipo_doc\" class=\"editingSize\">";
		
		$sql="SELECT $clave, $descripcion FROM $tabla";
		
		$resultado = mysqli_query($odonto_connection,$sql);
		if($resultado)
		{

			$data = array();
			$index = array();

			while( ($fila = mysqli_fetch_assoc($resultado)) )
				$html.='<option value="'.$fila[$clave].'">'.utf8_encode( $fila[$descripcion] ).'</option>';
		}
		else
			return AJAX_ERROR( mysqli_error($odonto_connection) ." " . $sql );
		
		$html.='</select>';
		
		return $html;
	}

	function ObtenerSelectTipoDocumento()
	{
		return CrearSelect("id_tipo_doc", "tipo_doc", "id_tipo_doc", "descripcion");
	}

	function ObtenerSelectCiudad()
	{
		return CrearSelect("id_ciudad", "ciudad", "id_ciudad", "descripcion");
	}

	function ObtenerIdViaje($id_reserva)
	{
		global $odonto_connection;

		$sql ="SELECT id_viaje FROM  `reserva` WHERE  `id_reserva` LIKE  '$id_reserva'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila1 = mysqli_fetch_assoc($resultado);
		return $fila1['id_viaje'];
	}

	function ObtenerResumenTitular($id_reserva)
	{
		global $odonto_connection;
			

		$sql ="SELECT id_viaje, id_persona FROM  `reserva` WHERE  `id_reserva` LIKE  '$id_reserva'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila1 = mysqli_fetch_assoc($resultado);
		$id_viaje=$fila1['id_viaje'];
		$id_persona=$fila1['id_persona'];
		
		return "Titular: " . ObtenerResumenPersona($id_persona) . SEPARADOR . ObtenerResumenViaje($id_viaje);
	}

	function ObtenerResumenPersona($id_persona)
	{
		global $odonto_connection;

		$sql ="SELECT apellido, nombre FROM  `persona` WHERE  `id_persona` LIKE  '$id_persona'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila2 = mysqli_fetch_assoc($resultado);
		$apellido=$fila2['apellido'];
		$nombre=$fila2['nombre'];
		
		return utf8_encode($apellido).", ".utf8_encode($nombre);
		//return "$apellido, $nombre";
	}

	function ObtenerResumenPersona_x_Reserva($id_reserva)
	{
		global $odonto_connection;

		$sql ="SELECT id_persona FROM  `reserva` WHERE  `id_reserva` LIKE  '$id_reserva'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila1 = mysqli_fetch_assoc($resultado);
		$id_persona=$fila1['id_persona'];
		
		return ObtenerResumenPersona($id_persona);
	}

	function ObtenerResumenViaje_x_Reserva($id_reserva)
	{
		global $odonto_connection;

		$sql ="SELECT id_viaje FROM  `reserva` WHERE  `id_reserva` LIKE  '$id_reserva'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila1 = mysqli_fetch_assoc($resultado);
		$id_viaje=$fila1['id_viaje'];
		
		return ObtenerResumenViaje($id_viaje);
	}

	function ObtenerResumenViaje($id_viaje)
	{
		global $odonto_connection;

		$sql ="SELECT * FROM  `viajes` WHERE  `id_viaje` LIKE  '$id_viaje'";
		$resultado = mysqli_query($odonto_connection,$sql);
		$fila = mysqli_fetch_assoc($resultado);
		$fecha=$fila['fecha'];								

		$trozos = explode ("-", $fecha);
		
		$vemos=array();
		$vemos['0']=$trozos['2'];
		$vemos['1']=$trozos['1'];
		$vemos['2']=$trozos['0'];
		$fecha = implode('/', $vemos);

		$fecha_llegada=$fila['fecha_llegada'];
		
		$trozos = explode ("-", $fecha_llegada);
		$vemos=array();
		$vemos['0']=$trozos['2'];
		$vemos['1']=$trozos['1'];
		$vemos['2']=$trozos['0'];
		$fecha_llegada = implode('/', $vemos);
		
		return "Destino: ". utf8_encode( $fila['detalle'] ). SEPARADOR . "Salida: $fecha"; // . SEPARADOR . "Regreso: $fecha_llegada";
	}
?>