function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
    results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

// Add Record
function addRecord() {
    // get values
	var id_pac = getParameterByName('id_pac');
    var first_name = $("#first_name").val();
    var last_name = $("#last_name").val();
    var dni = $("#dni").val();
    var email = $("#email").val();
    var doc = $("#doc").val();
    var vesti = $("#vesti").val();
    var profesional = $("#profesional").val();

    // Add record
    $.post("ajax/addRecord_historia.php", {
        id_pac: id_pac,
        first_name: first_name,
        last_name: last_name,
        dni: dni,
        email: email,
        doc: doc,
        vesti: vesti,
        profesional: profesional,
		
    }, function (data, status) {
        // close the popup
        $("#add_new_record_modal").modal("hide");
 window.location="historia.php?cual=2&id_pac="+id_pac;
        // read records again
        readRecords();

        // clear fields from the popup
        $("#first_name").val("");
        $("#last_name").val("");
        $("#dni").val("");
        $("#email").val("");
        $("#doc").val("");
        $("#vesti").val("");
        $("#profesional").val("");
		
		$("#odontogramita").html(val("doc"));
    });
}


// READ records
function readRecords() {
	var id_pac = getParameterByName('id_pac');	
	$.get("ajax/readRecords_historia.php?id_pac="+id_pac, {}, function (data, status) {
        $(".records_content").html(data);
    });
	$.get("ajax/readRecords_odontogramita.php?id_pac="+id_pac, {}, function (data, status) {
        $(".odontogramita").html(data);
    });
	
}


function DeleteUser(id) {
    var conf = confirm("Seguro borramos el item del historial?");
    if (conf == true) {
        $.post("ajax/deleteUser_historia.php", {
                id: id
            },
            function (data, status) {
                // reload Users by using readRecords();
                readRecords();
            }
        );
    }
}

function formato(texto){
  return texto.replace(/^(\d{4})-(\d{2})-(\d{2})$/g,'$3/$2/$1');
}

function GetUserDetails(id) {
    // Add User ID to the hidden field for furture usage
    $("#hidden_user_id").val(id);
    $.post("ajax/readUserDetails_historia.php", {
            id: id
        },
        function (data, status) {
            // PARSE json data
            var user = JSON.parse(data);
            var fecha = user.fecha;
			fecha = formato(fecha);
            // Assing existing values to the modal popup fields
            $("#update_first_name").val(fecha);
            $("#update_last_name").val(user.pieza);
            $("#update_dni").val(user.tratamiento);
            $("#update_email").val(user.observaciones);
            $("#update_predet").val(user.predet);
            $("#update_vesti").val(user.vesti);
            $("#update_profesional").val(user.profesional);
        }
    );
    // Open modal popup
    $("#update_user_modal").modal("show");
}

function UpdateUserDetails() {
    // get values
    var first_name = $("#update_first_name").val();
    var last_name = $("#update_last_name").val();
    var dni = $("#update_dni").val();
    var email = $("#update_email").val();
    var predet = $("#update_predet").val();
    var vesti = $("#update_vesti").val();
    var profesional = $("#update_profesional").val();

    // get hidden field value
    var id = $("#hidden_user_id").val();

    // Update the details by requesting to the server using ajax
    $.post("ajax/updateUserDetails_historia.php", {
            id: id,
            first_name: first_name,
            last_name: last_name,
            dni: dni,
            email: email,
            predet: predet,
            vesti: vesti,
            profesional: profesional,
        },
        function (data, status) {
            // hide modal popup
            $("#update_user_modal").modal("hide");
            // reload Users by using readRecords();
            readRecords();
        }
    );
}

$(document).ready(function () {
    // READ recods on page load
    readRecords(); // calling function
});